# Poisson_fit.R
# Fitting the Poisson to frequency data

# Load necessary libraries
library(ggplot2)
library(MASS)

# Read in data set
poisdata <- read.table(header=T,colClasses=c("numeric","numeric"),text="
y obsfreq
0   6
1  15
2  17 
3  29
4  20
5   6
6   5
7   1
8   1
9   0
10  0
")

# Generate offset y values for plot
poisdata <- transform(poisdata,yexp=y-0.1)
poisdata <- transform(poisdata,yobs=y+0.1)

# Print data
poisdata

# Convert tabulated data to raw form for R
ydata <- rep(poisdata[,"y"],poisdata$obsfreq)

# Calculate mean and variance
mean(ydata)
var(ydata)

# Fit Poisson distribution
fitout <- fitdistr(ydata,"poisson")
fitout

# Calculate expected frequencies
poisdata <- transform(poisdata,poisprob=dpois(poisdata$y,fitout$estimate))
poisdata <- transform(poisdata,expfreq=fitout$n*poisprob)

# Print revised data
poisdata

# Generate plot showing frequencies
ggplot(poisdata,aes(yobs,obsfreq))+
geom_bar(stat="identity",width=0.05,fill="blue")+
geom_point(color="blue",size=3)+
geom_bar(aes(yexp,expfreq),stat="identity",width=0.05,fill="red")+
geom_point(aes(yexp,expfreq),color="red",size=3)+
ggtitle("Fitting the Poisson to frequency data")


